/**
此文件包含 TTS 功能的实现
**/

const tts = chrome.tts;
function voiceTTS(selectedVoice, ttsText, enqueue) {
storage.get(['pitchValue', 'rateValue', 'volumeValue'], function(result) {
let pitchValue = result['pitchValue'];
let rateValue = result['rateValue'];
let volumeValue = result['volumeValue'];
let lang = localStorage['lang'];
const parameter = {
lang: lang,
enqueue: enqueue,
rate: rateValue,
pitch: pitchValue,
volume: volumeValue,
voiceName: selectedVoice
};
tts.speak(ttsText, parameter);
});
}
chrome.runtime.onMessage.addListener(function (message, callback) {
if (message.ttsState === `speak`) {
let getVoices = new Promise(function (resolve, reject) {
let selectedOption = localStorage[`selectedOption`];
tts.getVoices(function (voices) {
for (var i = 0, l = voices.length; i < l; i++) {
if (voices[i].voiceName === selectedOption)
resolve(voices[i].voiceName);
}
});
});
getVoices.then(function (value) {
voiceTTS(value, message.text, message.enqueue)
});
}
if (message.ttsState === `stop`) {
tts.stop();
}
});
