/**
此文件包含使用 node.js 自动创建脚本用户使用说明 html 文档的实现
**/

const fs = require(`fs`);
const path = require(`path`)
let txtDirname = path.join(__dirname,'userGuide', 'txt');
let htmlDirname = path.join(__dirname, 'userGuide', 'html');
console.log(`构建的文件:`);
let txtFileName = fs.readdirSync(txtDirname);
for (let i=0, l=txtFileName.length; i<l; i++) {
let fileName = txtFileName[i].split('.')
 let htmlFile =fileName[0] + '.html';
let txtPath = path.join(txtDirname,txtFileName[i]);
console.log(txtPath);
let htmlPath = path.join(htmlDirname, htmlFile);
console.log(htmlPath);
let htmlFront = `
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>
` + fileName[0] + `
</title>
<link href="guide.css" rel="stylesheet">
</head>
<body>
<div id="top">
<a href="../../userGuide.html">文档首页</a>
</div>
<hr>
<div id="text">
<p>
`;
let htmlBehind = `
</p>
</div>
<hr>
<a href="../../userGuide.html">文档首页</a>
</body>
</html>
`;
let result = fs.readFileSync(txtPath).toString();
let results = result.replace(/[\n]/g, `</ br>` + `\n`); 
let html = htmlFront + results + htmlBehind;
fs.writeFileSync(htmlPath, html, `utf-8`);
console.log(htmlPath);
}


let htmlFileName = fs.readdirSync(htmlDirname);
let link = '';
for (let i=0, l=htmlFileName.length; i<l; i++) {
let fileName = htmlFileName[i].split('.')
let linkStr = `<a class="description" href="userGuide/html/` + htmlFileName[i] + `">` + fileName[0] + `</a>`;
link = link + linkStr + `\n`;
}
let userGuideHtml = `
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>扩展说明文档</title>
<link href="userGuide.css" rel="stylesheet">
</head>
<body>
<div>
<a href="userGuide.html">文档首页</a>
</div>
<hr>
<div>
` + link + `
<hr>
</div>
</body>
<script src="userGuide.js"></script>
</html>
`;
fs.writeFileSync(path.join(__dirname, `userGuide.html`), userGuideHtml, `utf-8`);

console.log(`构建完成!`);