/**
此文件包含脚本全局开关功能的实现
**/
(function () {
    const storage = chrome.storage.sync;
    const transfer = [
        'navigation',
        'webTool',
        'readMouse'
    ];
    // 初始化状态
    for (let i = 0, l = transfer.length; i < l; i++) {
        storage.get(transfer[i], function (result) {
            if (result[transfer[i]] === undefined) {
                const initialization = {
                    'navigation': true,
                    'webTool': true,
                    'readMouse': false
                };
                storage.set(initialization, function () {
                    getStorage(transfer);
                    ttsSpeak('脚本开关初始化完成');
                });
            }
        });
    }

    // 打开页面记忆上次调整的状态
    function getStorage(key) {
        for (let i = 0, l = transfer.length; i < l; i++) {
            storage.get(key[i], function (result) {
                let element = document.querySelector('#' + transfer[i] + ' span');
                if (element)
                    if (result[key[i]] === true) {
                        element.classList.add('open');
                        element.textContent = '已开启';
                    }
                if (result[key[i]] === false) {
                    element.classList.add('close');
                    element.textContent = '已关闭';
                }
            });
        }
    }

    // 给按钮绑定点击事件
    let switchBtn = document.querySelectorAll('button.switch-btn');
    for (let i = 0, l = switchBtn.length || transfer.length; i < l; i++) {
        switchBtn[i].addEventListener('click', function () {
            let element = this.querySelector('span.state');
            let id = this.id;
            if (element.classList.contains('open')) {
                const obj = { [id]: false };
                storage.set(obj, function () {
                    element.classList.add('close');
                    element.classList.remove('open');
                    element.textContent = '已关闭';
                    ttsSpeak(element.parentNode.innerText);
                });
            }
            if (element.classList.contains('close')) {
                const obj = { [id]: true }
                storage.set(obj, function () {
                    element.classList.remove('close');
                    element.classList.add('open');
                    element.textContent = '已开启';
                    ttsSpeak(element.parentNode.innerText);
                });
            }
        }, null);
    }

    getStorage(transfer);
})();